/**
 * This file is a part of JSIDPlay - a Java SID Player
 * Main Developer: Joakim Eriksson (Dreamfabric.com)
 * Contact: joakime@sics.se
 * Web: http://www.dreamfabric.com/c64
 * ---------------------------------------------------
 */

package applet;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.Color;
import javax.swing.JComponent;

/**
 * Describe class SIDCanvas here.
 *
 *
 * Created: Tue Aug 02 14:53:07 2005
 *
 * @author <a href="mailto:Joakim@BOTBOX"></a>
 * @version 1.0
 */
public class SIDCanvas extends JComponent {

  private static final int ADSR_SIZE = 81;
  private static final int FRQ_SIZE = 81;
  private static final int SAMPLE_SIZE = 110;
  private int[] adsrBuffer = new int[ADSR_SIZE];
  private int[] frqBuffer = new int[FRQ_SIZE];
  private int[] sampleBuffer = new int[SAMPLE_SIZE];
  private int samplePos = 0;
  private int adsrPos;
  private int frqPos;

  private static final Color PENCOLOR = new Color(0x00c000);
  private static final Color BORDERCOLOR = new Color(0x204020);

  public SIDCanvas() {
    super();
    setFont(new Font("Monospaced", Font.PLAIN, 10));
    setForeground(Color.green);
    setBackground(Color.black);
    setOpaque(true);
    setDoubleBuffered(true);
  }

  public Dimension getPreferredSize() {
    return new Dimension(110 + ADSR_SIZE + FRQ_SIZE + 10, 80);
  }

  public void updateADSR(double value) {
    adsrBuffer[adsrPos] = (int) (value * 1000);
    adsrPos = (adsrPos + 1) % ADSR_SIZE;
  }

  public void updateFRQ(long value) {
    value = value / 8;
    if (value > 128) value = 128;
    frqBuffer[frqPos] = (int) value;
    frqPos = (frqPos + 1) % FRQ_SIZE;
  }

  public void updateSamples(int[] samples, int count) {
    // Store the samples...
    for (int i = 0, n = count; i < n; i += 2) {
      sampleBuffer[samplePos = (samplePos + 1) % SAMPLE_SIZE] = samples[i];
    }
  }

  public void paintComponent(Graphics g) {
    int height = getHeight();
    g.setColor(PENCOLOR);
    g.drawString("Osc Output", 6, 10);

    for (int i = 0, n = SAMPLE_SIZE - 1; i < n; i++) {
      g.drawLine(i, height - 10 - height *
		 sampleBuffer[(samplePos + i) % SAMPLE_SIZE] / 16000,
		 i + 1, height - 10 - height *
		 sampleBuffer[(samplePos + i + 1) % SAMPLE_SIZE] /
		 16000);
    }

    int pos = 115;
    g.drawString("ADSR Lv", pos, 10);
    for (int i = 0, n = ADSR_SIZE - 1; i < n; i++) {
      int ix = (adsrPos + i + ADSR_SIZE) % ADSR_SIZE;
      g.drawLine(pos + i, height - 10 - height * adsrBuffer[ix] / 1500,
		 i + pos + 1,
		 height - 10 - height *
		 adsrBuffer[(ix + 1) % ADSR_SIZE] / 1500);
    }

    pos += ADSR_SIZE + 5;
    g.drawString("Freq.", pos , 10);
    for (int i = 0, n = FRQ_SIZE - 1; i < n; i++) {
      int ix = (adsrPos + i + FRQ_SIZE) % FRQ_SIZE;
      g.drawLine(pos + i, height - 10 - height * frqBuffer[ix] / 200,
		 i + pos + 1, height - 10 -
		 height * frqBuffer[(ix + 1) % FRQ_SIZE] / 200);
    }

  }
}
